<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template name="methodDetail">
		<xsl:param name="title"/>
		<xsl:param name="nodeSet"/>
		
		<!-- Heading -->
		<a name="method_detail"></a>
		<table border="1" cellpadding="3" cellspacing="0" width="100%">
		  <tr class="TableHeaderStyle">
		    <td colspan="2">
			  <font size="+2">
				<b><xsl:value-of select="$title"/></b>
			  </font>
			</td>
		  </tr>
		</table>
		<br/>
		<xsl:for-each select="$nodeSet">
			<xsl:sort select="@name" />
			<xsl:variable name="full-name">
        <xsl:apply-templates select="current()" mode="DefinitionString"/>
      </xsl:variable>
			<xsl:variable name="inner-ref">
				<xsl:apply-templates select="current()" mode="method-ref"></xsl:apply-templates>
			</xsl:variable>
			<xsl:variable name="description">
				<xsl:apply-templates select="current()" mode="getDescription"/>
			</xsl:variable>
			<xsl:variable name="elName" select="@name"/>
			<a name="{$inner-ref}"><h3><xsl:value-of select="$elName"/></h3></a>
			<pre>
			
			<xsl:value-of select="$full-name"></xsl:value-of>
			</pre>
			<xsl:call-template name="printProperties">
				<xsl:with-param name="element" select="current()"></xsl:with-param>
				<xsl:with-param name="nodeset" select="Property"></xsl:with-param>
				<xsl:with-param name="property-names" select="Property/@name"></xsl:with-param>			
			</xsl:call-template>
			
			<!-- Print Element HyperLinks-->
			<xsl:call-template name="printHyperLinks">
				<xsl:with-param name="element" select="current()"></xsl:with-param>
			</xsl:call-template>					
			
			<hr/>
		</xsl:for-each>

	</xsl:template>
</xsl:stylesheet>
